/* this is os.error.inc */

/* Avoidable conditions (high bit IS on) */

DCL eOverFlow LIT '8001h';      /* integer overflow         */
DCL eZeroDivide LIT '8000h';    /* divide by zero           */
DCL eArrayBounds LIT '8006h';   /* bounds check violation   */
DCL eNDP LIT '8007h';           /* 8087 detected error      */

/* uts reserves 1100h to 15ffh              */
/* Unavoidable conditions (high bit is off) */

/* system errors */

DCL eOK LIT '0';               /* no error                 */
DCL eInvString LIT '129';      /* invalid string           */
DCL eNotSupport LIT '35';      /* request not supported    */
DCL eShare LIT '40';           /* file can't be shared     */
DCL eAccess LIT '38';          /* file access denied       */
DCL ePassword LIT '27';        /* password protected       */
DCL eCheckSum LIT '29';        /* checksum error           */
DCL eLocked LIT '30';          /* file is locked           */
DCL eBadPointer LIT '31';      /* bad pointer              */
DCL eAppNotFound LIT '34';     /* Application not found    */
DCL eEmulatorNotFound LIT '36';/* Emulator not found       */
DCL eSerialNotFound LIT '37';  /* Serial driver not found  */
DCL eStayingInBackground LIT '257';  /* App is staying in background */
DCL eWrongConfiguration  LIT '99';

/* memory manager errors */

DCL eOutOfMem LIT '2';        /* out of memory            */
DCL eInvMemBlock LIT '11';     /* invalid memory block     */
DCL eNotYourBlock LIT '10';    /* OsWhoAmI doesn't own memory block */
DCL eBadOffset    LIT '9';     /* Offset of ptr is > allocated size */
DCL eReallyBadOffset LIT '8';  /* Offset is > allocated size rounded up */

/* file system errors	*/

DCL eInvFileID LIT '200';      /* invalid file ID          */
DCL eInvFileFSN LIT '201';     /* invalid file FSN         */
DCL eFileNotFound LIT '33';   /* file does not exist      */
DCL eFileExists LIT '32';     /* file already exists      */
DCL eDeviceFull LIT '41';     /* device full              */
DCL eFileNotOpen LIT '205';    /* file not open            */
DCL eCrossFS LIT '220';        /* cross volume rename      */
DCL eBadConn LIT '221';        /* bad connection           */
DCL eOpen LIT '222';           /* file shouldn't be open   */
DCL eParam LIT '225';          /* bad parameter            */	
DCL eBadPath LIT '227';        /* syntax error             */
DCL eTooManyDev LIT '229';     /* too many devices         */
DCL eDevActive LIT '230';      /* device already active    */
DCL eDevNotActive LIT '231';   /* device not active        */
DCL eInvDirectory LIT '232';   /* invalid directory format */
DCL eInvBitMap LIT '233';      /* invalid bitmap format    */
DCL eDirNotFound LIT '234';    /* directory not found      */
DCL eProtectError LIT '49';    /* software protection error*/
DCL eInvalidMedia LIT '235';   /* invalid media in drive   */
DCL eInvalidDiskette LIT '236';/* invalid drive for disk   */
DCL eInvalidVolume LIT '237';  /* volume not found         */
DCL eTooManyFilesOpen LIT '238';/*Too many files open...   */
      
/* device driver errors		*/

DCL eInvalidDrive LIT '101';   /* invalid drive            */
DCL eInvalidSector LIT '102';  /* invalid sector           */
DCL eCRCData LIT '103';        /* CRC error in data        */
DCL eRecordNotFound LIT '104'; /* record not found         */
DCL eCRCID LIT '105';          /* CRC error in ID field    */
DCL eWriteProtect LIT '106';   /* device write protected   */
DCL eDevNotReady LIT '107';    /* device not ready         */
DCL eOther LIT '108';          /* unknown error            */

/* loader errors			*/

DCL eInvRec LIT '300'; 
DCL eInvFld LIT '301'; 
DCL eInvMod LIT '302'; 
DCL eInvBas LIT '303'; 
DCL eInvFix LIT '304'; 

/* 310 - 312 reserved for the NSA for some reason they */
/* cant say...                                         */

/* multi-tasking errors			*/

DCL eTooManyProc LIT '250';    /* too many processes       */
DCL eProcNotExist LIT '251';   /* process does not exist   */
DCL eSemaNotExist LIT '252';   /* semaphore does not exist */
DCL eTimeOut LIT '253';        /* request timed out        */
DCL eSemaBusy LIT '254';       /* the semaphore is busy    */

/* modem errors  */

DCL eModNotAnswer     LIT '400'; 
DCL eModTimeOut       LIT '401'; 
DCL eModLossCarrier   LIT '402'; 
DCL eModParity        LIT '403'; 
DCL eModCrc           LIT '404'; 
DCL eModBadLength     LIT '405';
DCL eModInvalidNumber LIT '406';
DCL eModNotActive     LIT '407';
DCL eModBufOverflow   LIT '408';
DCL eModemNotThere    LIT '409';

/* GPIB errors */

DCL eGPIBBus LIT '450'; 
DCL eGPIBTimeOut LIT '451'; 
DCL eGPIBNotResp LIT '452'; 

